function exportEMachine(em, spreadsheet_name)

spreadsheet_name = spreadsheet_name + ".xlsx";

% Main data
mainData = table('Size', [0 3], ...
    'VariableTypes', ["string", "cell", "string"], ...
    'VariableNames', ["Main Parameters", "value", "unit"]);

mainData(end+1, :) = {"Full Name", {em.fullName}, ""};
mainData(end+1, :) = {"Rated power", {em.ratedPwr}, "kW"};
mainData(end+1, :) = {"Moment of inertia", {em.inertia}, "kg*m^2"};
mainData(end+1, :) = {"Maximum speed", {em.maxSpd}, "rpm"};
mainData(end+1, :) = {"Mass", {em.mass}, "kg"};

% limit and motoring torque characteristics
limDataHeader = table("rpm", "Nm", "Nm", 'VariableNames', ...
    ["speed", "maxTorque", "minTorque"]);
limData = table(em.maxTrq.GridVectors{1}(:) .* 30/pi, em.maxTrq.Values(:), ...
    em.minTrq.Values(:));

% Efficiency
eff = [0, em.effMap.GridVectors{1} .* 30/pi; 
    em.effMap.GridVectors{2}(:), em.effMap.Values' .* 100];

% Write to spreadsheet
writetable(mainData, spreadsheet_name, Sheet = "main")
writetable(limDataHeader, spreadsheet_name, Sheet = "lim")
writetable(limData, spreadsheet_name, Sheet = "lim", ...
    WriteVariableNames = false, Range = "A3")
writematrix(eff, spreadsheet_name, Sheet = "eff")

end